%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%function intermediate_lsm()
clear all; close all;

%%%% read original image %%%%%
M = imread('init.JPG');

X = rgb2gray(M);
[X_row, X_col] = size(X);

%%%% make binary image %%%%%
for i=1:X_row
    for j=1:X_col
        if(X(i,j) < 125) 
            X(i,j) = 255;
        else
            X(i,j) = 0;
        end
    end
end
 
% figure;
% imshow(X);
 
%%%% initialize the zero level set function
phi = zeros(size(X));

for i=80:430
    for j=75:450
        if(X(i,j) == 255)
            phi(i,j) = 1;
        end
    end
end

figure;
[C1 h1] = contour(phi, [0 0], 'r'); % original = 2007 nodes

%%% adjusting the size for target image
new_C1(1,:) = (C1(1,[2:15, 17:30, 32:45, 47:60, 62:75, 77:90, 92:105, ...
    107:120, 122:135, 137:150, 152:165, 167:180, 182:195, 197:219,...
    221:237, 239:255, 257:273, 275:291, 293:309,...
    311:327, 329:345, 347:363, 365:381, 383:399,...
    401:417, 419:435, 437:453, 455:471, 473:489,...
    491:507, 509:525, 527:543, 545:561, 563:579,...
    581:597, 599:1800,...    
    1802:1813, 1815:1826, 1828:1839, 1841:1852, 1854:1865,...
    1867:1878, 1880:1891, 1893:1904, 1906:1917, 1919:1930,...
    1932:1943, 1945:1956, 1958:1969, 1971:1982, 1984:1995,...
    1997:2008]));
new_C1(2,:) = (C1(2,[2:15, 17:30, 32:45, 47:60, 62:75, 77:90, 92:105, ...
    107:120, 122:135, 137:150, 152:165, 167:180, 182:195, 197:219,...
    221:237, 239:255, 257:273, 275:291, 293:309,...
    311:327, 329:345, 347:363, 365:381, 383:399,...
    401:417, 419:435, 437:453, 455:471, 473:489,...
    491:507, 509:525, 527:543, 545:561, 563:579,...
    581:597, 599:1800,...    
    1802:1813, 1815:1826, 1828:1839, 1841:1852, 1854:1865,...
    1867:1878, 1880:1891, 1893:1904, 1906:1917, 1919:1930,...
    1932:1943, 1945:1956, 1958:1969, 1971:1982, 1984:1995,...
    1997:2008]));


% figure;
% plot(new_C1(1,1:1956), new_C1(2, 1:1956), 'ro', 'MarkerSize', 1); %resized boundary for initial
% hold on;
% plot(new_C1(1,1), new_C1(2,1), 'bx', 'MarkerSize',10);
% hold on;
% plot(new_C1(1,3:100), new_C1(2, 3:100), 'g+', 'MarkerSize',2);

fin_C1(1,:) = new_C1(1, [1568:1956, 1:1567]);
fin_C1(2,:) = new_C1(2, [1568:1956, 1:1567]);

% figure;
% plot(fin_C1(1,:), fin_C1(2,:), 'ro', 'MarkerSize', 1); 
% hold on;
% plot(fin_C1(1,1), fin_C1(2,1), 'bx', 'MarkerSize', 10); 
% hold on;
% plot(fin_C1(1, 3:100), fin_C1(2,3:100), 'g+', 'MarkerSize', 2); 

% figure;
% plot(fin_C1(1, 1:8:1956), fin_C1(2, 1:8:1956), 'ro', 'MarkerSize', 1); 

%%%% mesh boundary coordinate %%%%%
sim_C1 = fin_C1(:, 1:8:1956);

figure;
plot(sim_C1(1, :), sim_C1(2, :), 'ro', 'MarkerSize', 2); 

fid = fopen('init_coor', 'w'); 

for i=1:size(sim_C1,2)
    fprintf(fid, '%f\t%f\n', sim_C1(1,i), sim_C1(2,i));
end

fclose(fid);

% figure;
% imshow(flipud(phi)); %phi will be used as a mask
% saveas(gcf, 'initial_bin', 'eps2c');

%%%% read the target image %%%%%
M = imread('inter.JPG');

M = imresize(M, [559 579]);
X = rgb2gray(M);
[X_row, X_col] = size(X);

% %%%% make binary image %%%%%
for i=1:X_row
    for j=1:X_col
        if(X(i,j) < 105) 
            X(i,j) = 255;
        else
            X(i,j) = 0;
        end
    end
end
 
%  figure;
%  imshow(X);

%%%% generate the level set function for the target image %%%%%
data = zeros(size(X));

for i=95:450
    for j=90:450
        if(X(i,j) == 255)
            data(i,j) = 1;
        end
    end
end

figure;
[C2 h2] = contour(data, [0 0], 'b'); % original = 1956 nodes

new_C2(1,:) = C2(1, [2:1952, 1954:1958]);
new_C2(2,:) = C2(2, [2:1952, 1954:1958]);

% figure;
% plot(new_C2(1,:), new_C2(2,:), 'bo', 'MarkerSize', 1);
% hold on;
% plot(new_C2(1,1), new_C2(2,1), 'kx', 'MarkerSize', 10); 
% hold on;
% plot(new_C2(1, 3:100), new_C2(2, 3:100), 'g+', 'MarkerSize',2);
% hold on;
% plot(new_C2(1, 467), new_C2(2, 467), 'kx', 'MarkerSize', 10);

fin_C2(1,:) = new_C2(1, [467:1956, 1:466]); 
fin_C2(2,:) = new_C2(2, [467:1956, 1:466]);

% figure; 
% plot(fin_C2(1,:), fin_C2(2,:), 'bo', 'MarkerSize', 1);
% hold on;
% plot(fin_C2(1,1), fin_C2(2,1), 'kx', 'MarkerSize', 10); 
% hold on;
% plot(fin_C2(1, 3:100), fin_C2(2, 3:100), 'g+', 'MarkerSize', 2);
% 
% figure;
% plot(fin_C2(1, 1:8:1956), fin_C2(2, 1:8:1956), 'ro', 'MarkerSize', 1); 

sim_C2 = fin_C2(:, 1:8:1956);
tmp(1,:) = sim_C2(1, 1:174);
tmp(2,:) = sim_C2(2, 1:174);

tmp(:,175) = [376;242];
tmp(:,176) = [381;242];

C = cat(2, tmp, sim_C2(:, 176:186));
tmp = C;
C = cat(2, tmp, sim_C2(:, 188:245));
sim_C2 = C;

figure;
plot(sim_C2(1, :), sim_C2(2, :), 'ro', 'MarkerSize', 2); 

fid = fopen('inter_coor', 'w'); 

for i=1:size(sim_C2,2)
    fprintf(fid, '%f\t%f\n', sim_C2(1,i), sim_C2(2,i));
end

fclose(fid);

%%%% generate intermediate boundary %%%%%
v = sim_C2 - sim_C1; 

fid = fopen('intermediate_2_1', 'w');
for i=1:size(sim_C1,2)
    sim_C3(:,i) = sim_C1(:,i) + (1/2)*v(:,i);
    fprintf(fid, '%f\t%f\n', sim_C3(1,i), sim_C3(2,i));
end
fclose(fid);

figure; 
plot(sim_C3(1,:), sim_C3(2,:), 'go', 'MarkerSize', 2);
hold on;
plot(sim_C1(1,:), sim_C1(2,:), 'ro', 'MarkerSize', 2);
hold on;
plot(sim_C2(1,:), sim_C2(2,:), 'bo', 'MarkerSize', 2);


saveas(gcf, 'intermediate_2_1', 'eps2c');



% figure;
% imshow(flipud(data));
% saveas(gcf, 'inter_bin', 'eps2c');


% seg = chenvese(data, phi, 6, 1, 'chan');
% myseg = imresize(seg, 1/0.3578);
% 
% h = figure;
% showphi(data, myseg, 6);
% saveas(flipud(gcf), 'iter_6', 'eps2c');
% 
% h = figure; 
% contour(phi, [0 0], 'b');
% hold on;
% contour(myseg, [0 0], 'r');
% saveas(gcf, 'iter_6_contour', 'eps2c');
